<?php

namespace SEOPressPro\Actions\Api;

if ( ! defined('ABSPATH')) {
    exit;
}

use SEOPress\Core\Hooks\ExecuteHooks;

class SchemaManual implements ExecuteHooks
{
    /**
     * @var int|null
     */
    private $current_user;

    public function hooks()
    {
        $this->current_user = wp_get_current_user()->ID;
        add_action('rest_api_init', [$this, 'register']);
    }

    public function register()
    {
        register_rest_route('seopress/v1', '/posts/(?P<id>\d+)/schemas-manual', [
            'methods' => 'GET',
            'callback' => [$this, 'processGet'],
            'args' => [
                'id' => [
                    'validate_callback' => function ($param, $request, $key) {
                        return is_numeric($param);
                    },
                ],
            ],
            'permission_callback' => function($request) {
                $post_id = $request['id'];
                $current_user = $this->current_user ? $this->current_user : wp_get_current_user()->ID;

                if ( ! user_can( $current_user, 'edit_post', $post_id )) {
                    return false;
                }

                return true;
            },
        ]);
        register_rest_route('seopress/v1', '/posts/(?P<id>\d+)/schemas-manual', [
            'methods' => 'PUT',
            'callback' => [$this, 'processPut'],
            'args' => [
                'id' => [
                    'validate_callback' => function ($param, $request, $key) {
                        return is_numeric($param);
                    },
                ],
            ],
            'permission_callback' => function ($request) {
                $post_id = $request['id'];
                return current_user_can('edit_post', $post_id);
            },
        ]);
    }

    public function cleanData($data)
    {
        if (empty($data)) {
            return $data;
        }

        foreach ($data as $key => $value) {
            if ('howto' === $value['_seopress_pro_rich_snippets_type']) {
                $data[$key]['_seopress_pro_rich_snippets_how_to'] = array_values(
                    isset($value['_seopress_pro_rich_snippets_how_to']) ? $value['_seopress_pro_rich_snippets_how_to'] : []
                );
            }
        }

        return $data;
    }

    public function processGet(\WP_REST_Request $request)
    {
        $id = $request->get_param('id');
        $data = get_post_meta($id, '_seopress_pro_schemas_manual', true);

        if (empty($data)) {
            $data = [];
        }

        $schemasAvailable = seopress_pro_get_service('FormSchemaAvailable')->getData();

        $fields = [];
        foreach ($schemasAvailable as $key => $item) {
            $class = new $item['class']();
            $fields[$item['type']] = $class->getFields($id);
        }

        $data = $this->cleanData($data);

        return new \WP_REST_Response(['data' => $data, 'fields' => $fields, 'schemas' => $schemasAvailable]);
    }

    public function processPut(\WP_REST_Request $request)
    {
        $id = $request->get_param('id');
        $params = $request->get_params();

        if ( ! isset($params['schemas'])) {
            return new \WP_REST_Response([
                'code' => 'error',
                'code_message' => 'missing_parameters',
            ], 403);
        }

        update_post_meta($id, '_seopress_pro_schemas_manual', $params['schemas']);

        return new \WP_REST_Response([
            'code' => 'success',
        ]);
    }
}
